﻿
using System.Collections.Generic;

public sealed class VariableChangedManager {

    private static readonly VariableChangedManager instance = new VariableChangedManager();
    private static Dictionary<string, List<VariableChanged>> monitor;


    private VariableChangedManager()
    {

    }

    public static VariableChangedManager Instance
    {
        get
        {
            return instance;
        }
    }
    
    public void Reprace(string key, object newVariable)
    {
        List<VariableChanged> changeds = monitor[key];
        foreach(VariableChanged changed in changeds)
        {
            changed.old = changed.val;
            changed.val = newVariable;
            if(changed.call is ValueChangedManager)
            {
                ValueChangedManager manager = (ValueChangedManager)changed.call;
                manager.VariableChanged(changed);
            }
        }
    }

    private void SetMonitor(VariableChanged variableChanged,string key)
    {
        List<VariableChanged> variable;
        if((monitor[key].Count == null) && (monitor[key].Count == 0))
        {
            variable = new List<VariableChanged>();
            variable.Add(variableChanged);
            monitor[key] = (variable);
        }
        else
        {
            monitor[key].Add(variableChanged);
        }
    }


    public static List<VariableChanged> GetMonitor(string index)
    {
        return monitor[index];
    }

    public void AddMonitor(ValueChangedManager callClass,string key, object newValue, object currentValue = null)
    {
        if((callClass is ValueChangedManager) && (key != null))
        {
            VariableChanged variableChanged = new VariableChanged();
            variableChanged.key = key;
            variableChanged.old = (currentValue == null)?newValue:currentValue;
            variableChanged.val = newValue;
            variableChanged.call = (callClass == null)? (ValueChangedManager)callClass : callClass;

            SetMonitor(variableChanged,key);

        }
    }

}
