﻿/**
 * Unity C# Script
 * sunMove
 * Date : 2017/11/08
 * Author :animeing
**/
using System;
using UnityEngine;

[RequireComponent(typeof(Rigidbody))]
public class sunRotate : MonoBehaviour
{

    [Range(0.0f, 100.0f)]
    public float day = 10f;
    public Rigidbody sun;
    const float DAYS = 0.4f;
    public int date = 0;
    private bool counted = true;
    public DateTime Date { get; private set; }
    public int Year;

    private void Awake()
    {
        if (sun == null)
        {
            sun = gameObject.GetComponent<Rigidbody>();
        }
        Year = (Year == 0) ?1990:Year;
        Date = new DateTime(Year,1,1);
    }
	
	// Update is called once per frame
	void Update ()
    {
        var X = sun.transform.localRotation.x;
        X = X * Math.Sign(X);
        Days(X);
        sun.gameObject.transform.localEulerAngles = new Vector3(
            90+(Time.time*day),
            90,
            0
        );
    }

    void Days(Single X)
    {
        if (!counted &&
            X >= DAYS &&
            !(X >= DAYS + 0.05))
        {
            NextDay();
        }
        if (!(X < DAYS + 0.07))
        {
            counted = false;
        }
    }

    void NextDay()
    {
        date++;
        Date = Date.AddDays(1);
        counted = true;
    }
}
