﻿/**
 * Unity C# Script
 * Image Fade in out & Fade Up Code
 * Date : 2017/02/02
 * Author :animeing
**/

using UnityEngine;
using UnityEngine.UI;
using UnityEngine.SceneManagement;

[RequireComponent(typeof(Image))]
public class img_Fade : MonoBehaviour
{

    private Image img;
    private float alfa;
    private float color;
    private enum Mode
    {
        leadedAllScript = 0,
        donLeadAllEnded,
        fadeOnlyLeadedDonLeadScript,
        expansionOnlyLeadedDonLoadScript,
        DonloadExpansion,
        DonloadFade
    }
    [SerializeField]
    private Mode mode = Mode.leadedAllScript;
    private enum exMode {
        sizeChenge = 0,
        scaleChenge
    }
    [SerializeField]
    private exMode exmode = exMode.sizeChenge;
    public float speed = 0;
    [SerializeField, HeaderAttribute("Fade Selector")]
    public bool fade_in = true;
    public bool fade_out = false;
    [SerializeField, HeaderAttribute("Fade Color")]
    public bool white = false;
    public bool black = true;
    [SerializeField, HeaderAttribute("Select Onece")]
    public bool destroy = true;
    public bool unActive = false;
    public bool sceneMove = false;
    [SerializeField, HeaderAttribute("If scene Move checked setting")]
    public string MoveSceneName = "";
    public bool DonDestoryMove = false;
    public GameObject DonDestoryObject = null;
    [SerializeField, HeaderAttribute("Expansion Fade")]
    public bool expansion = false;
    [SerializeField, Header("Start Size")]
    public float S_width;
    public float S_height;

    [SerializeField, Header("End Size")]
    public float E_width;
    public float E_height;

    [SerializeField, Header("Expantion Speed (multiplication by speed)")]
    public float speed_scale = 0.0f;

    //true size
    private float width;
    private float heidht;

    private bool width_in;
    private bool height_in;
    
    [HideInInspector]
    public bool setEND = false;
    [HideInInspector]
    public bool w_exEnded = false;
    [HideInInspector]
    public bool h_exEnded = false;
    [HideInInspector]
    public bool exEnded = false;
    
    private RectTransform transform;

    void Awake()
    {
        img = this.GetComponent<Image>();
        if (expansion)
        {
            transform = gameObject.GetComponent<RectTransform>();

            if ((int)exmode == 0) {
                transform.sizeDelta = new Vector2(S_width, S_height);
            } else if((int)exmode == 1){
                transform.sizeDelta = new Vector2(E_width, E_height);
            }
            width_in = S_width > E_width;
            height_in = S_height > E_height;

            width = S_width;
            heidht = S_height;
        }
    }

    // Use this for initialization
    void Start()
    {
        if (fade_in)
        {
            alfa = 0.0f;
        }
        else if (fade_out)
        {
            alfa = 1.0f;
        } else {
            alfa = 1.0f;
        }

        if (white)
        {
            color = 255.0f;
        }
        else if (black)
        {
            color = 0f;
        }
    }

    void Ended()
    {
        if ((!(exEnded ^ expansion)) && !((setEND ^ (fade_in||fade_out) ))) {
            if (destroy)
            {
                Destroy(this.gameObject);
            }
            else if (unActive)
            {
                gameObject.SetActive(false);
            }
            else if (sceneMove)
            {
                if (!destroy)
                {
                    DontDestroyOnLoad(this);
                }
                if (DonDestoryMove)
                {
                    if (DonDestoryObject == null)
                    {
                        DontDestroyOnLoad(this);
                    }
                    else
                    {
                        DontDestroyOnLoad(DonDestoryObject);
                    }
                }
                SceneManager.LoadScene(MoveSceneName);
            }
        }
    }

    // Update is called once per frame
    void Update()
    {
        if ((setEND && ((int)mode != 1 ^ (int)mode != 2)) ^ (int)mode != 5)
        {
            if (fade_in)
            {
                alfa += speed * Time.deltaTime;
                if (alfa >= 1f)
                {
                    alfa = 1f;
                    setEND = true;
                    Ended();
                }
                else
                {
                    setEND = false;
                }
            }
            else if (fade_out)
            {
                alfa -= speed * Time.deltaTime;
                if (alfa <= 0f)
                {
                    alfa = 0f;
                    setEND = true;
                    Ended();
                }
                else
                {
                    setEND = false;
                }
            }
        }

        var width_rotate = 0;
        var height_rotate = 0;
        if ((exEnded && ((int)mode != 1 ^ (int)mode != 3)) ^ (int)mode != 4)
        {
            if (expansion)
            {
                if (width_in)
                {
                    width -= (E_width * speed * speed_scale) * Time.deltaTime;
                    if (width <= 0)
                    {
                        width_rotate = 180;
                    }
                    if (width < E_width)
                    {
                        w_exEnded = true;
                        width = E_width;
                    }
                }
                else
                {
                    width += (E_width * speed * speed_scale) * Time.deltaTime;
                    if (width <= 0)
                    {
                        width_rotate = 180;
                    }
                    if (width > E_width)
                    {
                        w_exEnded = true;
                        width = E_width;
                    }
                }
                if (height_in)
                {
                    heidht -= (E_height * speed * speed_scale) * Time.deltaTime;
                    if (heidht <= 0)
                    {
                        height_rotate = 180;
                    }
                    if (heidht < E_height)
                    {
                        h_exEnded = true;
                        heidht = E_height;
                        if (w_exEnded)
                        {
                            exEnded = true;
                            Ended();
                        }
                    }
                }
                else
                {
                    heidht += (E_height * speed * speed_scale) * Time.deltaTime;
                    if (heidht <= 0)
                    {
                        height_rotate = 180;
                    }
                    if (heidht > E_height)
                    {
                        h_exEnded = true;
                        heidht = E_height;
                        if (w_exEnded)
                        {
                            exEnded = true;
                            Ended();
                        }
                    }
                }

                var w = ((int)(Mathf.Floor(width)) >> -1);
                var h = ((int)(Mathf.Floor(heidht)) >> -1);
                if (w == 0)
                {
                    w = 1;
                }
                if (h == 0)
                {
                    h = 1;
                }
                if ((int)exmode == 0) {
                    transform.rotation = Quaternion.Euler(height_rotate, width_rotate, 0);
                    transform.sizeDelta = new Vector2(width * w, heidht * h);
                } else if((int)exmode == 1) {
                    transform.localScale = new Vector2(width / E_width, heidht / E_height);
                }
            }
        }
        img.color = new Color(color, color, color, alfa);
    }
}
