﻿using System.Collections.Generic;
using System.Diagnostics;

public class UnificationDTOManager
{
    public static readonly UnificationDTOManager instance = new UnificationDTOManager();

    private Dictionary<string, List<string>> dataColumns = new Dictionary<string, List<string>>();

    private UnificationDTOManager() { }

    public enum ColumnState
    {
        UN_MATCH,
        NEW_DTO,
        MATH
    }

    public void SetDTOColumns(string dtoName, List<string> key)
    {
        dataColumns.Add(dtoName, key);
    }

    /// <summary>
    /// DTOが同じものであるか判断します。
    /// 新しいDTOの場合常にTrueを返します。
    /// </summary>
    /// <param name="dtoName">DTO名</param>
    /// <param name="keys">DTOキー</param>
    /// <returns>指定したDTO名の持つDTOと同じであるか状態を返します。</returns>
    public ColumnState CheckColumnDTO(string dtoName, List<string> keys)
    {
        if (dataColumns.ContainsKey(dtoName))
        {
            List<string> currentKeys = dataColumns[dtoName];
            foreach (string key in currentKeys)
            {
                if (!keys.Contains(key))
                {
                    return ColumnState.UN_MATCH;
                }
            }
            return ColumnState.MATH;
        }
        else
        {
            return ColumnState.NEW_DTO;
        }
    }

    /// <summary>
    /// 対象の名前を持つDtoの管理を終了します。
    /// </summary>
    /// <param name="dtoName">dto名</param>
    public void UnManagementDTOByKey(string dtoName)
    {
        var frame = new StackFrame(1);
        if (frame.GetMethod().ReflectedType.Name == "DataCacheManager")
        {
            if (dataColumns.ContainsKey(dtoName))
            {
                dataColumns.Remove(dtoName);
            }
        }
        else
        {
            throw new FunctionCallBlockException("This function is automatically called from DataCacheManager.");
        }
    }


}
