﻿using System;
using System.Collections.Generic;

public class DatasDTO 
{
    private Dictionary<string, DataStruct> data = new Dictionary<string, DataStruct>();
    private List<string> impkeys = new List<string>();
    private int impColumnLenght;
    public int columnLenght
    {
        get
        {
            return impColumnLenght;
        }
        private set
        {
            impColumnLenght = value;
        }
    }

    public List<string> keys
    {
        get
        {
            return impkeys;
        }
        private set
        {
            impkeys = value;
        }
    }

    private string impDtoName;
    public string dtoName
    {
        get
        {
            return impDtoName;
        }
        private set
        {
            impDtoName = value;
        }
    }

    /// <summary>
    /// 情報を詳細にしたデータを持ちます。
    /// </summary>
    public struct DataStruct
    {
        private Type impType;
        public Type type {
            get
            {
                return impType;
            }
            private set
            {
                impType = value;
            }
        }
        private object impData;
        public object data {
            get
            {
                return impData;
            }
            private set
            {
                impData = value;
            }
        }

        private bool impBool;
        public bool isBoolean
        {
            get
            {
                return impBool;
            }
            private set
            {
                impBool = value;
            }
        }

        public void SetData(object data)
        {
            this.data = data;
            type = data.GetType();
        }
    }

    /// <summary>
    /// テーブル名を指定して、レコードを作ります。
    /// </summary>
    /// <param name="dtoName"></param>
    public DatasDTO(string dtoName)
    {
        this.dtoName = dtoName;
    }

    /// <summary>
    /// レコードのフィールドを格納します。
    /// レコードの持つ全てのフィールドがたとえフィールドに情報がなくとも
    /// 格納される必要があります。
    /// </summary>
    /// <param name="key">カラム名</param>
    /// <param name="data">フィールド</param>
    public void SetData(Keys key,object data)
    {
        columnLenght++;
        keys.Add(key.key);
        this.data.Add(key.key, CreateDataStruct(data));
    }

    /// <summary>
    /// レコードの情報を取得します。
    /// </summary>
    /// <param name="key">カラム名</param>
    /// <returns>フィールド情報を含む情報</returns>
    public DataStruct GetDataStruct(Keys key)
    {
        return data[key.key];
    }
    
    private DataStruct CreateDataStruct(object data)
    {
        DataStruct dataStruct = new DataStruct();
        dataStruct.SetData(data);
        return dataStruct;
    }

    private void SetPrimatyKey(Keys key)
    {
    }
}
