﻿using System.Collections.Generic;

public sealed class DataCacheManager
{

    public static readonly DataCacheManager instance = new DataCacheManager();
    //DTO name => DTOs
    private static Dictionary<string, List<DatasDTO>> datas = new Dictionary<string, List<DatasDTO>>();

    private DataCacheManager()
    {

    }

    public List<DatasDTO> GetDatas(string key)
    {
        return datas[key];
    }

    /// <summary>
    /// cached by DTO
    /// </summary>
    /// <param name="key">DTO Name</param>
    /// <param name="data">DTOs</param>
    public void SetDatas(DTOList data)
    {
        datas[data.dtoName] = data;
    }

    public void UnManagementDTOByKey(string dtoName)
    {
        if (datas.ContainsKey(dtoName))
        {
            datas.Remove(dtoName);
            UnificationDTOManager.instance.UnManagementDTOByKey(dtoName);
        }
    }

    public void Delete(string dtoName, int line)
    {
        if (datas.ContainsKey(dtoName))
        {
            List<DatasDTO> data = datas[dtoName];
            data.RemoveAt(line);
        }
    }

    public List<DatasDTO> DataSummary(string dtoName,string columnName,object summaryData)
    {
        List<DatasDTO> returnData = new List<DatasDTO>();

        foreach(DatasDTO dto in datas[dtoName]){
            if(dto.GetDataStruct(Keys.CreateKeys(columnName)).data == summaryData)
            {
                returnData.Add(dto);
            }
        }

        return returnData;
    }
}
