﻿using System.Collections.Generic;


public class DTOList : List<DatasDTO> {

    private string impDtoName;
    public string dtoName
    {
        get
        {
            return impDtoName;
        }
        private set
        {
            impDtoName = value;
        }
    }

    public DTOList():base(){
    }

    public void SetDtoName(string dtoName)
    {
        this.dtoName = dtoName;
    }
    /// <summary>
    /// 同じDTOをまとめます。
    /// この関数を使うにはすべてのカラム名がすでにAddしたものと一致している必要があります。
    /// 初めてこの関数を呼ぶ場合は、DTOのカラム名をすべて含んでいる必要があります。
    /// </summary>
    /// <param name="item">DTO</param>
    new public void Add(DatasDTO item)
    {
        if (dtoName == null || dtoName == item.dtoName)
        {
            dtoName = item.dtoName;
            var unificationDTOManager = UnificationDTOManager.instance;
            UnificationDTOManager.ColumnState columnState = unificationDTOManager.CheckColumnDTO(dtoName, item.keys);
            if (columnState != UnificationDTOManager.ColumnState.UN_MATCH)
            {
                if (columnState == UnificationDTOManager.ColumnState.NEW_DTO)
                {
                    unificationDTOManager.SetDTOColumns(dtoName, item.keys);
                }
                base.Add(item);
            }
            else
            {
                throw new UnificationException(
                    "This DTOName is already in use.\r\n"+
                    "If they are the same, check the DTO Column."
                );
            }
        }
        else
        {
            throw new UnificationException(
                "The name of dto must be unique for this List variable.\r\n" +
                "This List dtoName : "+dtoName+"\r\n" +
                "New dtoName : "+item.dtoName);
        }
    }

}
