/**
 * Unity C# Script
 * Unity Data ToString Value
 * Date : 2017/02/08
 * Author :animeing
**/

using System;
using System.IO;
using System.Collections.Generic;
using UnityEngine;

/// <summary>
/// ϐϊs
/// </summary>
public class ToValue
{
    /// <summary>
    /// L[R[hstringɕϊ܂B
    /// </summary>
    /// <param name="keys">L[R[h</param>
    /// <returns>L[R[hstringɕϊ</returns>
    public string ToString(KeyCode[] keys) {
        string str = "";
        for (var i = 0; i < keys.Length; i++) {
            str += (char)keys[i];
        }
        return str;
    }

    /// <summary>
    /// L[R[hstringɕϊ܂B
    /// </summary>
    /// <param name="key">L[R[h</param>
    /// <returns>L[R[hstringɕϊ</returns>
    public string ToString(KeyCode key) {
        return ((char)key).ToString();
    }

    /// <summary>
    /// lbg[Nstringɕϊ܂B
    /// </summary>
    /// <param name="key">lbg[N</param>
    /// <returns>L[R[hstringɕϊ</returns>
    public string ToString(WWW key)
    {
        return key.text;
    }

    /// <summary>
    /// Q[IuWFNgIuWFNgɕϊ܂B
    /// </summary>
    /// <param name="obj">Q[IuWFNg</param>
    /// <returns>Q[IuWFNg</returns>
    public string ToString(GameObject obj) {
        return obj.name;
    }

    /// <summary>
    /// ColorJ[R[hɕϊ܂B
    /// </summary>
    /// <param name="key">Unity Color</param>
    /// <returns>J[R[hɕϊstring</returns>
    public string ToString(Color colorcode) {
        string ret = "#";
        ret += colorcode.r * 255 + "" + colorcode.g * 255 + "" + colorcode.b * 255 + ""+colorcode.a * 255;
        return ret;
    }


    /// <summary>
    /// L[R[hcharɕϊ܂B
    /// </summary>
    /// <param name="key">L[R[h</param>
    /// <returns>L[R[hcharɕϊ</returns>
    public char ToChar(KeyCode key) {
        return (char)key;
    }

    /// <summary>
    /// L[R[h̔zɕϊ܂B
    /// </summary>
    /// <param name="str">ϊ镶</param>
    /// <returns>ϊꂽL[R[hz</returns>
    public KeyCode[] ToKeyCode(string str) {
        KeyCode[] keys = new KeyCode[str.Length];
        for (var i = 0; i < str.Length; i++) {
            keys[i] = (KeyCode)str[i];
        }
        return keys;
    }

    /// <summary>
    /// L[R[hɕϊ܂B
    /// </summary>
    /// <param name="c">ϊ镶</param>
    /// <returns>ϊL[R[h</returns>
    public KeyCode ToKeyCode(char c) {
        return (KeyCode)c;
    }

    /// <summary>
    /// Colorɕϊ܂B
    /// </summary>
    /// <param name="colorCode">J[R[h</param>
    /// <returns> 1 = bool  2 = int  3 = float  4 = string</returns>
    public Color ToColor(string colorCode) {
        float r = 0f;
        float b = 0f;
        float g = 0f;
        float a = 0f;
        colorCode = colorCode.Replace("#", "");
        if(colorCode.Length == 4 || colorCode.Length == 3) {
            string rs = colorCode.Substring(0, 1);
            rs += rs;
            int ri = Convert.ToInt32(rs, 16);
            r = ri / 255;
            string bs = colorCode.Substring(1, 1);
            bs += bs;
            int bi = Convert.ToInt32(bs, 16);
            b = bi / 255;
            string gs = colorCode.Substring(2, 1);
            gs += gs;
            int gi = Convert.ToInt32(bs, 16);
            g = gi / 255;
            a = 255;
            if (colorCode.Length == 4) {
                int ai = Convert.ToInt32(colorCode.Substring(3, 1)+ colorCode.Substring(3, 1), 16);
                a = ai / 255;
            }

        } else {
            string rs = colorCode.Substring(0, 2);
            int ri = Convert.ToInt32(rs, 16);
            r = ri / 255;
            string bs = colorCode.Substring(2, 2);
            int bi = Convert.ToInt32(bs, 16);
            b = bi / 255;
            string gs = colorCode.Substring(4, 2);
            int gi = Convert.ToInt32(bs, 16);
            g = gi / 255;
            a = 255;
            if (colorCode.Length == 8) {
                int ai = Convert.ToInt32(colorCode.Substring(6, 2), 16);
                a = ai / 255;
            }

        }
        return new Color(r, g, b, a);
    }

    /// <summary>
    /// stringœnꂽϐׂ̂^𒲂ׂ
    /// </summary>
    /// <returns> 1 = bool  2 = int  3 = float  4 = string</returns>
    public int what_this_value(string str) {
        int ret = 0;
        int value = 0;
        float f = 0f;
        if (str == "true" || str == "false") {
            ret = 1;
        } else if (int.TryParse(str, out value)) {
            ret = 2;
        } else if (float.TryParse(str, out f)) {
            ret = 3;
        } else {
            ret = 4;
        }
        if (ret == 0) {
            Debug.Log("<color=red>ERROR!!</color>");
        }
        return ret;
    }

    /// <summary>
    /// ̔z𕶎ɕϊ܂B
    /// </summary>
    /// <param name="ints">ϊ鐔̔z</param>
    /// <returns>ϊ̕</returns>
    public string[] tostrings(int[] ints)
    {
        var str = new string[ints.Length];
        var i = 0;
        foreach (int integer in ints)
        {
            str[i] = integer.ToString("x4");
            i++;
        }
        return str;
    }

    /// <summary>
    /// _t̔z𕶎ɕϊ܂B
    /// </summary>
    /// <param name="ints">ϊ镂_t̔z</param>
    /// <returns>ϊ̕</returns>
    public string[] tostrings(float[] floats)
    {
        var str = new string[floats.Length];
        var i = 0;
        foreach (float float_v in floats)
        {
            str[i] = float_v.ToString();
            i++;
        }
        return str;
    }
    
    /// <summary>
    /// Flag̔z𕶎ɕϊ܂B
    /// </summary>
    /// <param name="bools">ϊFlag̔z</param>
    /// <returns>ϊ̕</returns>
    public string[] tostrings(bool[] bools)
    {
        var str = new string[bools.Length];
        var i = 0;
        foreach (bool boolean in bools)
        {
            str[i] = boolean.ToString();
            i++;
        }
        return str;
    }

    /// <summary>
    /// Flag̔zɕϊ܂B
    /// </summary>
    /// <param name="bools">ϊ镶</param>
    /// <returns>ϊFlag̔z</returns>
    public bool[] tobool(string[] str)
    {
        var bools = new bool[str.Length];
        var i = 0;
        foreach (string boolean in str)
        {
            bools[i] = bool.Parse(boolean);
            i++;
        }
        return bools;
    }

    /// <summary>
    /// 𐔎̔zɕϊ܂B
    /// </summary>
    /// <param name="bools">ϊ镶</param>
    /// <returns>ϊ̐̔z</returns>
    public int[] toint(string[] str)
    {
        var values = new int[str.Length];
        var i = 0;
        foreach (string integer in str)
        {
            values[i] = Convert.ToInt32(integer, 16);
            i++;
        }
        return values;
    }

    /// <summary>
    /// 𕂓_t̐̔zɕϊ܂B
    /// </summary>
    /// <param name="bools">ϊ镶</param>
    /// <returns>ϊ̕_t̐̔z</returns>
    public float[] tofloat(string[] str)
    {
        var values = new float[str.Length];
        var i = 0;
        foreach (string floats in str)
        {
            values[i] = float.Parse(floats);
            i++;
        }
        return values;
    }

    /// <summary>
    /// List𕂓_t̐Listɕϊ܂B
    /// </summary>
    /// <param name="bools">ϊ镶List</param>
    /// <returns>ϊ̕_t̐List</returns>
    public List<float> tofloat(List<string> str)
    {
        var values = new List<float>();
        var i = 0;
        foreach (string floats in str)
        {
            values.Add(float.Parse(floats));
            i++;
        }
        return values;
    }
    
    public float toFloat(byte[] Bytes)
    {
        return BitConverter.ToSingle(Bytes, 0);
    }

    public byte[] toByte(float Float)
    {
        return BitConverter.GetBytes(Float);
    }
    private string Extension(string fileName)
    {
        return new FileInfo(fileName).Extension;
    }
    public AudioType ToAudioType(string fileName)
    {
#if UNITY_IOS
        return AudioType.AUDIOQUEUE;
#endif
        switch (Extension(fileName).ToLower())
        {
            case ".mpeg":
            case ".mp2":
            case ".m4a":
            case ".mp3":
                return AudioType.MPEG;
            case ".wav":
                return AudioType.WAV;
            case ".aif":
            case ".aiff":
                return AudioType.AIFF;
            case ".it":
                return AudioType.IT;
            case ".mod":
                return AudioType.MOD;
            case ".oga":
            case ".ogg":
                return AudioType.OGGVORBIS;
            case ".s3m":
                return AudioType.S3M;
            case ".vag":
                return AudioType.VAG;
            case ".xm":
                return AudioType.XM;
            case ".xma":
                return AudioType.XMA;
        }
        return AudioType.UNKNOWN;
    }
}
