﻿/**
 * Unity C# Script
 * Data Save
 * Date : 2017/11/24
 * Author :animeing
**/
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class SceneSettings : MonoBehaviour {

    public bool DontDestory = true;
    public PlaySettings[] values;
    public enum Object
    {
        Text = 1,
        Slider,
        Image,
        Button,
        Another
    }
    /// <summary>
    /// this value is scene save data
    /// key :ObjectName or saveName
    /// </summary>
    public Dictionary<string, object> Setting = new Dictionary<string, object>();

    private void Awake()
    {

        if (DontDestory)
        {
            DontDestroyOnLoad(this);
        }
    }
    
    private void OnEnable()
    {
        setValues();
    }

    public void setValues()
    {
        var loop = values.Length;
        for(int i = 0; i < loop; i++)
        {
            if ((values[i].form != Object.Another && values[i].objects != null) ||
                (values[i].form == Object.Another && values[i].AnotherText.name != null))
            {
                inputValuse(i);
            }
            else
            {
                Debug.LogError("Please check setting [object: "+i+" ]");
            }
        }
    }

    private void inputValuse(int count)
    {

        switch (values[count].form)
        {
            case Object.Text:
                Setting[values[count].objects.name] = values[count].objects.GetComponent<Text>().text;
                break;

            case Object.Slider:
                Setting[values[count].objects.name] = values[count].objects.GetComponent<Slider>().value;
                break;

            case Object.Image:
                Setting[values[count].objects.name] = values[count].objects.GetComponent<Image>().sprite;
                break;

            case Object.Button:
                Setting[values[count].objects.name] = values[count].objects.GetComponent<Button>().onClick;
                break;

            case Object.Another:
                if (values[count].AnotherText != null)
                {
                    Setting[values[count].AnotherText.name] = values[count].AnotherText.value;
                }
                else
                {
                    Debug.LogError("Another text is not setting!! [ " + count + " ]");
                }
                break;

            default:
                Debug.LogError("form is not setting!! [ "+count+" ]");
                break;
        }
    }

    [System.Serializable]
    public class PlaySettings
    {
        [SerializeField]
        internal GameObject objects;
        [SerializeField]
        internal Object form = Object.Text;
        [SerializeField, HeaderAttribute("Set when \"Form\" is \"Another\"")]
        public DicVary AnotherText;
    }

    [System.Serializable]
    public class DicVary
    {
        public string name;
        public string value;
    }
}
