/**
* Unity C# Script
* Binary Save & Load Source
* Date : 2016/03/17
* Remake : 2017/04/04
* Auther : animeing
**/
using System;
using System.IO;
using System.IO.Compression;
using System.Text;
using System.Security.Cryptography;
using UnityEngine;

/// <summary>
/// t@CɃf[^Z[uE[hs
/// </summary>
public class SaveProgram{

#if UNITY_STANDALONE
    private readonly string folder = Application.dataPath+"/";
#elif UNITY_ANDROID
    private readonly string folder = Application.persistentDataPath;
#endif
    

    /// <summary>
    /// f[^Z[u
    /// </summary>
    /// <param name="savenum">Z[uf[^̃f[^ԍ</param>
    /// <param name="str">Z[uf[^z</param>
    public void Save(int savenum, string[] str) {
        FileStream BinaryFile;
#if UNITY_EDITOR
        BinaryFile = new FileStream("Assets/Save/save_" + savenum + ".save", FileMode.Create, FileAccess.ReadWrite);
#else
		BinaryFile = new FileStream(folder+"save_"+savenum+".save", FileMode.Create, FileAccess.ReadWrite);
#endif

        var Writer = new BinaryWriter(BinaryFile);
        try
        {
            Writer.Write(str.Length);
            for (int i = 0; i < str.Length; i++)
            {
                Writer.Write(str[i]);
            }
        }
        catch (Exception e)
        {
            Debug.LogError( e );
        }
        finally
        {
            Writer.Close();
            BinaryFile.Close();
        }
    }



    /// <summary>
    /// Z[uꂽf[^擾B
    /// f[^͎̔z񏇂ɕԂB
    /// </summary>
    /// <param name="savenum">Z[uf[^̃f[^ԍ</param>
    /// <returns>Z[uf[^string[] ɂĕԂB</returns>
    public string[] Load(int savenum) {
        FileStream BinaryFile;
#if UNITY_EDITOR
        BinaryFile = new FileStream("Assets/Save/save_" + savenum + ".save", FileMode.Open, FileAccess.Read);
#else
		BinaryFile = new FileStream(folder+"save_"+savenum+".save", FileMode.Open, FileAccess.Read);
#endif

        var Reader = new BinaryReader(BinaryFile);
        int lenght = Reader.ReadInt32();

        string[] str = new string[lenght];

        try
        {

            for (int i = 0; i < lenght; i++)
            {
                str[i] = Reader.ReadString();
            }
        }catch(Exception e)
        {
            Debug.LogError( e );
        }
        finally
        {
            Reader.Close();
            BinaryFile.Close();
        }

        return str;

    }

    

    /// <summary>
    /// Íăf[^Z[u
    /// </summary>
    /// <param name="savenum">Z[uf[^̃f[^ԍ</param>
    /// <param name="str">Z[uf[^z</param>
    /// <param name="compression">ksꍇtrue(Í͍s܂B) łȂꍇ false</param>
    public void EncSave(int savenum, string[] str,bool compression)
    {
        string password = Application.productName;
        var rijndael = new RijndaelManaged();

        byte[] key, iv;
        PassKey(
            password,
            rijndael.KeySize,
            out key,
            rijndael.BlockSize,
            out iv);

        rijndael.Key = key;
        rijndael.IV = iv;
        ICryptoTransform encryptor = rijndael.CreateEncryptor();
        string[] ret = new string[str.Length];
        try
        {
            for (var i = 0; i < str.Length; i++)
            {
                if (!compression)
                {
                    byte[] strBytes = Encoding.UTF8.GetBytes(str[i]);
                    byte[] encBytes = encryptor.TransformFinalBlock(strBytes, 0, strBytes.Length);
                    ret[i] = Convert.ToBase64String(encBytes);
                }
                else
                {
                    string word = str[i];
                    ret[i] = Compression(word);
                }
            }
        }
        catch (Exception e)
        {
            Debug.LogError( e );
        }
        finally
        {
            encryptor.Dispose();
        }
        Save(savenum, ret);
    }

    /// <summary>
    /// Íăf[^Z[u
    /// </summary>
    /// <param name="savenum">Z[uf[^̃f[^ԍ</param>
    /// <param name="str">Z[uf[^z</param>
    public void EncSave(int savenum, string[] str)
    {
        EncSave(savenum, str, false);
    }


    /// <summary>
    /// ÍZ[uꂽf[^擾B
    /// f[^͎̔z񏇂ɕԂB
    /// </summary>
    /// <param name="savenum">Z[uf[^̃f[^ԍ</param>
    /// <returns>Z[uf[^string[] ɂĕԂB</returns>
    public string[] DecLoad(int savenum)
    {
        return DecLoad(savenum, false);
    }



    public void Desave(int savenum,string[] str)
    {
        for (var i = 0; i < str.Length; i++)
        {
            str[i] = Compression(str[i]);
        }
        EncSave(savenum, str);
    }

    /// <summary>
    /// ÍZ[uꂽf[^擾B
    /// f[^̓Z[u̔z񏇂ɕԂB
    /// </summary>
    /// <param name="savenum">Z[uf[^̃f[^ԍ</param>
    /// <param name="compression">𓀂sꍇtrue łȂꍇ false</param>
    /// <returns>Z[uf[^string[] ɂĕԂB</returns>
    public string[] DecLoad(int savenum,bool compression)
    {
        string password = Application.productName;
        var rijndael = new RijndaelManaged();
        byte[] key, iv;

        PassKey(
            password,
            rijndael.KeySize,
            out key,
            rijndael.BlockSize,
            out iv);
        rijndael.Key = key;
        rijndael.IV = iv;

        ICryptoTransform decryptor = rijndael.CreateDecryptor();
        string[] load = Load(savenum);
        string[] ret = new string[load.Length];
        try
        {
            for (var i = 0; i < load.Length; i++)
            {
                if (compression)
                {
                    ret[i] = Decompression(load[i]);
                }
                else
                {
                    byte[] str = Convert.FromBase64String(load[i]);
                    byte[] decBytes = decryptor.TransformFinalBlock(str, 0, str.Length);
                    ret[i] = Encoding.UTF8.GetString(decBytes);
                }
            }
        }
        catch (Exception e)
        {
            Debug.LogError( e );
        }
        finally
        {
            decryptor.Dispose();
        }
        return ret;
    }


    public string[] DeLoad(int savenum)
    {
        string[] ret = DecLoad(savenum);
        for (var i = 0; i < ret.Length; i++)
        {
            ret[i] = Decompression(ret[i]);
        }
        return ret;
    }

    /// <summary>
    /// Z[uf[^邩肷
    /// </summary>
    /// <param name="savenum">肷Z[uf[^ԍ</param>
    /// <returns>t@Cꍇ true Ȃꍇflase</returns>
    public bool FileChecker(int savenum)
    {
        string path;
        string filename = "save_" + savenum + ".save";
        bool ret = false;
#if UNITY_EDITOR
        path = "Assets/Save/";
#else
		path = folder;
#endif
        if (File.Exists(path + filename))
        {
            ret = true;
        }
        return ret;
    }

    /// <summary>
    /// w肵Z[uf[^폜B
    /// </summary>
    /// <param name="savenum">Z[uf[^ԍ</param>
    /// <returns>Z[uf[^폜ꂽꍇ true łȂꍇ false
    public bool Dele(int savenum)
    {
        string path;
        string filename = "save_" + savenum + ".save";
        bool ret = true;
#if UNITY_EDITOR
        path = "Assets/Save/";
#else
		path = folder;
#endif
        if (File.Exists(path + filename))
        {
            try
            {
                File.Delete(path + filename);
            }
            catch (IOException e)
            {
                ret = false;
            }
        }
        else
        {
            ret = false;
        }

        return ret;
    }

    /// <summary>
    /// kB
    /// </summary>
    /// <param name="str">k镶</param>
    /// <returns>kꂽ</returns>
    public string Compression(string str)
    {
        var ms = new MemoryStream();
        var cs = new DeflateStream(ms, CompressionMode.Compress, true);
        string ret = null;
        try
        {
            byte[] src = Encoding.Unicode.GetBytes(str);
            cs.Write(src, 0, src.Length);
        }catch(Exception e)
        {
            Debug.LogError( e );
        }
        finally
        {
            cs.Close();
        }
        try
        {
            byte[] dest = ms.ToArray();
            ret = Encoding.Unicode.GetString(dest);
        }catch(Exception e)
        {
            Debug.LogError(e);
        }
        finally
        {
            ms.Close();
        }
        return ret;
    }

    /// <summary>
    /// kꂽ𓀂B
    /// </summary>
    /// <param name="str">𓀂镶</param>
    /// <returns>𓀂ꂽ</returns>
    public string Decompression(string str)
    {
        var cs = new DeflateStream(GetMemoryStream(str), CompressionMode.Decompress);
        var ms = new MemoryStream();
        string ret = null;
        try
        {
            int rb;
            while ((rb = cs.ReadByte()) != -1)
            {
                ms.WriteByte((byte)rb);
            }
            ret = Encoding.Unicode.GetString(ms.ToArray());
        }
        catch(Exception e)
        {
            Debug.LogError( e );
        }
        finally
        {
            ms.Close();
            cs.Close();
        }

        return ret;
    }

    private void PassKey(string password, int keySize, out byte[] key, int blockSize, out byte[] iv)
    {
        byte[] salt = Encoding.ASCII.GetBytes("0000" + Application.productName + "0000");
        salt = new MD5CryptoServiceProvider().ComputeHash(salt);
        var deriveBytes = new Rfc2898DeriveBytes(password, salt);
        deriveBytes.IterationCount = 525;
        key = deriveBytes.GetBytes(keySize / 8);
        iv = deriveBytes.GetBytes(blockSize / 8);
    }

    private void PassKey(string password, int keySize, out byte[] key, int blockSize, out byte[] iv,string salts)
    {
        byte[] salt = Encoding.ASCII.GetBytes(salts);
        salt = new MD5CryptoServiceProvider().ComputeHash(salt);
        var deriveBytes = new Rfc2898DeriveBytes(password, salt);
        deriveBytes.IterationCount = 525;
        key = deriveBytes.GetBytes(keySize / 8);
        iv = deriveBytes.GetBytes(blockSize / 8);
    }

    private void PassKey(string password, int keySize, out byte[] key, int blockSize, out byte[] iv, byte[] salt)
    {
        salt = new MD5CryptoServiceProvider().ComputeHash(salt);
        var deriveBytes = new Rfc2898DeriveBytes(password, salt);
        deriveBytes.IterationCount = 525;
        key = deriveBytes.GetBytes(keySize / 8);
        iv = deriveBytes.GetBytes(blockSize / 8);
    }

    private MemoryStream GetMemoryStream(string text)
    {
        return new MemoryStream(Encoding.Unicode.GetBytes(text));
    }
}