﻿/**
* Unity C# Script
* Web Connector
* Date : 2016/11/12
* Auther : animeing
**/
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Networking;

public class NetWorkConnector
{

    /// <summary>
    /// Web page path
    /// </summary>
    public string src = "";
    public enum Communication{
        Get = 0,
        Post,
        Texture,
        Audio,
        Movie
    }
    public enum NowEvent{
        Nus = -2,
        Error,
        Loaded,
        Start,
        Progress
    }
    public enum ProgressOptions
    {
        Download = 1,
        Upload
    }
    private enum ErrorOptions
    {
        pathError = 0,
        netWorkError,
        AudioNoSupport
    }

    /// <summary>
    /// Cleate network class
    /// </summary>
    /// <param name="src">Network source url</param>
    public NetWorkConnector(string src)
    {
        this.src = src;
    }



    /// <summary>
    /// Cleate network class
    /// </summary>
    public NetWorkConnector()
    {
    }

    /// <summary>
    /// Cleate network connector
    /// </summary>
    /// <param name="form">transmission data.  When there is no transmission data null</param>
    /// <param name="option">Connect option. Default Get</param>
    /// <param name="audioType">When "Connect option" is "Audio" set "audio type"</param>
    /// <returns>Connector data</returns>
    public UnityWebRequest UnityConnector(WWWForm form = null, Communication option = Communication.Get,AudioType audioType = AudioType.UNKNOWN)
    {
        if (option == Communication.Audio&&audioType == AudioType.UNKNOWN)
        {
            audioType = new ToValue().ToAudioType(src);
            if(audioType == AudioType.UNKNOWN)
            {
                Error(ErrorOptions.AudioNoSupport);
            }
        }
        if (src == "") Error(ErrorOptions.pathError);
        if (form != null && option == Communication.Get) option = Communication.Post;
        switch (option) {
            case Communication.Post:
                return UnityWebRequest.Post(src, form);
            case Communication.Get:
                return UnityWebRequest.Get(src);
            case Communication.Texture:
                return UnityWebRequestTexture.GetTexture(src);
            case Communication.Audio:
                return UnityWebRequestMultimedia.GetAudioClip(src, audioType);
            case Communication.Movie:
                return UnityWebRequestMultimedia.GetMovieTexture(src);
        }
        return UnityWebRequest.Get(src);
    }

    /// <summary>
    /// Convert the acquired data to a texture.
    /// </summary>
    /// <param name="req">Connector</param>
    /// <returns>Texture</returns>
    public Texture GetTexture(UnityWebRequest req)
    {
        return DownloadHandlerTexture.GetContent(req);
    }

    public UnityWebRequest GetTexture()
    {
        var Connector = UnityConnector(null,Communication.Texture);
        Send(Connector);
        return Connector;
    }


    /// <summary>
    /// Convert the acquired data to a AudioClip.
    /// </summary>
    /// <param name="req">Connector</param>
    /// <returns>AudioClip</returns>
    public AudioClip GetAudioClip(UnityWebRequest req)
    {
        return DownloadHandlerAudioClip.GetContent(req);
    }

    /// <summary>
    /// Convert the acquired data to a MovieTexture.
    /// </summary>
    /// <param name="req">Connector</param>
    /// <returns>AudioClip</returns>
    public MovieTexture GetMovie(UnityWebRequest req)
    {
        return DownloadHandlerMovieTexture.GetContent(req);
    }

    public string GetScript(UnityWebRequest req)
    {
        return DownloadHandlerBuffer.GetContent(req);
    }

    /// <summary>
    /// Send to now event
    /// </summary>
    /// <param name="req">Target data</param>
    /// <returns>Event</returns>
    public NowEvent Event(UnityWebRequest req)
    {
        var ret = NowEvent.Start;
        if (req.isDone)
        {
            ret = NowEvent.Loaded;
        }
        else if (req.isNetworkError)
        {
            ret = NowEvent.Error;
            Error(ErrorOptions.netWorkError);
        }
        else
        {
            ret = (src == "")?NowEvent.Error:NowEvent.Progress;
        }
        return ret;
    }

    /// <summary>
    /// Start acquisition
    /// </summary>
    /// <param name="req">target data</param>
    public void Send(UnityWebRequest req)
    {
        if (src != "")
        {
            req.SendWebRequest();
        }
        else
        {
            Error(ErrorOptions.pathError);
        }
    }

    /// <summary>
    /// Cleate transmission data.
    /// </summary>
    /// <param name="form">transmission data.</param>
    /// <returns>form data</returns>
    public WWWForm Form(Dictionary<string, string> form)
    {
        var F = new WWWForm();
        foreach (KeyValuePair<string, string> keys in form)
        {
            F.AddField(keys.Key, keys.Value);
        }
        return F;
    }

    /// <summary>
    /// Cleate transmission data.
    /// </summary>
    /// <param name="form">transmission data.</param>
    /// <returns>form data</returns>
    public WWWForm Form(string key, string value)
    {
        var F = new WWWForm();
        F.AddField(key, value);
        return F;
    }

    /// <summary>
    /// Cleate transmission data.
    /// </summary>
    /// <param name="form">transmission data.</param>
    /// <returns>form data</returns>
    public WWWForm Form(WWWForm form, string key, string value)
    {
        form.AddField(key, value);
        return form;
    }

    /// <summary>
    /// Cleate transmission data.
    /// </summary>
    /// <param name="form">transmission data.</param>
    /// <returns>form data</returns>
    public WWWForm Form(WWWForm form, Dictionary<string, string> key)
    {
        foreach (KeyValuePair<string, string> keys in key)
        {
            form.AddField(keys.Key, keys.Value);
        }
        return form;
    }

    /// <summary>
    /// Cleate transmission data.
    /// </summary>
    /// <param name="form">transmission data.</param>
    public void Form(ref WWWForm form, Dictionary<string, string> key)
    {
        foreach (KeyValuePair<string, string> keys in key)
        {
            form.AddField(keys.Key, keys.Value);
        }
    }
    /// <summary>
    /// Cleate transmission data.
    /// </summary>
    /// <param name="form">transmission data.</param>
    /// <returns>form data</returns>
    public void Form(ref WWWForm form, string key, string value)
    {
        form.AddField(key, value);
    }

    /// <summary>
    /// now progress
    /// </summary>
    /// <param name="req">target data</param>
    /// <param name="progress">"download progress" or "upload progress"</param>
    /// <returns>now progress</returns>
    public float Progress(UnityWebRequest req, ProgressOptions progress = ProgressOptions.Download)
    {
        switch (progress)
        {
            case ProgressOptions.Download:
                return req.downloadProgress;
            case ProgressOptions.Upload:
                return req.uploadProgress;
        }
        return -1f;
    }

    /// <summary>
    /// WWW Connector (Unity Absolute Plan)
    /// </summary>
    /// <param name="com">Access</param>
    /// <param name="form">Post Data</param>
    /// <returns>WWW</returns>
    public WWW Connector(Communication com = Communication.Get, Dictionary<string, string> form = null)
    {
        WWW ret = null;
        switch (com)
        {
            case Communication.Get:
                ret = new WWW(src);
                break;

            case Communication.Post:
                ret = Connector(Form(form));
                break;
        }
        return ret;
    }

    /// <summary>
    /// WWW Connector (Unity Absolute Plan)
    /// </summary>
    /// <param name="form">Post Data</param>
    /// <returns>WWW</returns>
    public WWW Connector(WWWForm form)
    {
        return new WWW(src, form);
    }

    /// <summary>
    /// Send to now event (Unity Absolute Plan)
    /// </summary>
    /// <param name="www">Target data</param>
    /// <returns>Event</returns>
    public NowEvent Event(WWW www)
    {
        return www.isDone ?NowEvent.Loaded : NowEvent.Progress;
    }
    
    private void Error(ErrorOptions option)
    {
        switch (option)
        {
            case ErrorOptions.pathError:
                Debug.LogError("Please set path\n\rNetWorkConnector.path");
                break;
            case ErrorOptions.netWorkError:
                Debug.LogError("Network Error\n\rPlease check to path");
                break;
            case ErrorOptions.AudioNoSupport:
                Debug.LogError("File extension error\n\rThis file extension is no support");
                break;
        }
    }
}

