﻿/**
 * Unity C# Script
 * DataFile Checker
 * Date 2017/11/05
 * Author animeing
 **/
using System.Collections.Generic;
using System.IO;
using UnityEngine;

public class DataFileCheck {

    public enum Data
    {
        csv = 1,
        json,
        xml
    };

    /// <summary>
    /// dataPathデータを返す
    /// </summary>
    /// <param name="path">ファイル名(拡張しなし)</param>
    /// <returns>Data(csv json xml)を返す</returns>
    public Data FullPathDATA(string path)
    {
        var ret = (Data)0;
        if (!File.Exists(Application.dataPath + "/" + path))
        {
            Debug.LogError(@path+" is not found");
        }
        else
        {
            using (var stream = new StreamReader(Application.dataPath + "/" + path, System.Text.Encoding.GetEncoding("UTF-8")))
            {
                using (var reader = new StringReader(stream.ReadToEnd()))
                {
                    ret = CheckData(reader);
                }
            }
        }
        return ret;
    }
    /// <summary>
    /// Resources/Data/にあるcsvデータを読み込む
    /// </summary>
    /// <param name="str">ファイル名(拡張しなし)</param>
    /// <returns>Data(csv json xml)を返す</returns>
    public Data ProjectDATA(string str)
    {
        TextAsset csv = Resources.Load("Data/" + str, typeof(TextAsset)) as TextAsset;
        StringReader reader = new StringReader(csv.text);
        return CheckData(reader);
    }

    private Data CheckData(StringReader stream)
    {
        var ret = (Data)0;
        var FileList = new List<string>();
        FileList = fileList(stream);

        if (!checkXML(FileList))
        {
            if (!checkJson(FileList))
            {
                ret = Data.csv;
            }
            else
            {
                ret = Data.json;
            }
        }
        else
        {
            ret = Data.xml;
        }
        return ret;
    }

    private List<string> fileList(StringReader reader)
    {
        var fileList = new List<string>();
        while (reader.Peek() > -1)
        {
            fileList.Add(reader.ReadLine());
        }
        return fileList;

    }

    public bool checkXML(List<string> list)
    {
        return list[0].Contains("<?xml version=\"1.0\"");
    }
    public bool checkJson(List<string> list)
    {
        var open = 0;
        var close = 0;
        for(var i = 0; i < list.Count; i++)
        {
            open += CountKeywrod(DeleteKeyword(list[i],'"'), '{');
            close += CountKeywrod(DeleteKeyword(list[i], '"'), '}');
        }
        return (open!= 0)?open == close:false;
    }
    private int CountKeywrod(string str, char ch)
    {
        return str.Length - str.Replace(ch.ToString(), "").Length;
    }
    private string DeleteKeyword(string str,char ch)
    {
        while (str.IndexOf("\\\"") > -1)
        {
            var i = str.IndexOf("\\\"");
            str = str.Remove(i, i + 1);
        }

        while (str.IndexOf(ch.ToString()) > -1)
        {
            var i = str.IndexOf(ch.ToString());
            str = str.Remove(i, 1);
            var c = str.IndexOf(ch.ToString());
            if (c <= -1)
            {
                str =str.Remove(i, (c <= 0) ? 1:c);
            } else
            {
                str = str.Remove(i);
            }
        }
        return str;
    }
}
