﻿using UnityEngine;
using System.Collections.Generic;
using System.IO;

public class CsvWriter : MonoBehaviour {


	public void WriteCSV(List<List<string>> csv,string path)
    {
        var fileParentPath = Application.dataPath+"/"+path;

        var fi = new FileInfo(fileParentPath);
        var sw = fi.AppendText();

        for (var i = 0; i < csv.Count; i++)
        {
            string line = "";
            for(var j = 0; j < csv[i].Count; j++)
            {
                if(line == "")
                {
                    line += csv[i][j];
                } else {
                    line += ","+csv[i][j];
                }
            }
            sw.WriteLine(line);
        }
        sw.Flush();
        sw.Close();
    }

    public void LineReplace(List<List<string>> csv ,int position ,string path)
    {
        var fileParentPath = Application.dataPath + "/" + path;
        var csvreader = GetCsvreader();
        var oldcsv = csvreader.ProjectFolderReadCSV(path);
        StreamWriter stream = new StreamWriter(fileParentPath, false, System.Text.Encoding.UTF8);
        for (var i = 0; i < oldcsv.Count; i++)
        {
            string line = "";
            if (i != position)
            {
                for (var j = 0; j < oldcsv[i].Count; j++)
                {
                    if (line == "")
                    {
                        line += oldcsv[i][j];
                    }
                    else
                    {
                        line += "," + oldcsv[i][j];
                    }
                }
            }
            else
            {
                for (var j = 0; j < oldcsv[0].Count; j++)
                {
                    if (line == "")
                    {
                        line += csv[0][j];
                    }
                    else
                    {
                        line += "," + csv[0][j];
                    }
                }

            }
            stream.WriteLine(line);
        }
        stream.Close();

    }

    private static CsvReader GetCsvreader()
    {
        return new CsvReader();
    }
}
