
using System;

public class Keys
{
    private string impkey = null;

    public string key
    {
        get
        {
            return impkey;
        }
        private set
        {
            impkey = value.GetHashCode().ToString();
        }
    }

    private object[] impKeyName;

    public object[] keyName {
        get {
            return impKeyName;
        }
        private set{
            impKeyName = value;
        }
    }

    private Type impKeyType;

    public Type keyType
    {
        get
        {
            return impKeyType;
        }
        private set
        {
            impKeyType = value;
        }
    }
    public static Keys CreateKeys(params string[] keys)
    {
        return new Keys(CreateKey(keys));
    }

    public Keys(params string[] keys)
    {
        keyName = keys;
        keyType = keys.GetType();
        key = CreateKey(keys);
    }

    public Keys(string key)
    {
        this.key = key;
    }

    private Keys() { }

    private static string CreateKey(params string[] keys)
    {
        var key = "";
        for(int count = 0; count < keys.Length; count++)
        {
            key += keys[count].ToString();
        }

        return key;
    }
    

    override public string ToString()
    {
        return key;
    }
}