﻿/**
 * Unity C# Script
 * 2DGame Charactor Moveing
 * Date 2016/01/02
 * Author animeing
 **/
using UnityEngine;

public class CharactorMoving :MonoBehaviour {

    public enum move_mode
    {
        PlayerMove = 1,
        CpuMove
    };
    public move_mode moveMode = move_mode.CpuMove;
    [Range(0.0f, 10.0f)]
    public float MoveSpeed = 0.2f;
    [Range(0.0f, 10.0f)]
    public float RotationSpeed = 0.2f;
    private KeyGetter keygetter;

    private void Awake()
    {
        keygetter = new KeyGetter();
    }


    public void CharactorMove (float x, float y, float speed) {
		Rigidbody2D rigidbody2d = GetComponent<Rigidbody2D>();
		rigidbody2d.velocity = new Vector2(x * speed, y * speed);
	}
	public void CharactorMove (float x, float y, float z,float speed) {
		this.transform.Translate (x*speed, y*speed, z*speed);
	}

	public void CharactorRotation (float x, float y,float z,float w,float speed) {
		Rigidbody rigidbody = GetComponent<Rigidbody>();
		rigidbody.rotation = new Quaternion(x * speed, y * speed, z * speed, w * speed);
	}

	public void CharactorRotation (float x, float y, float z, float speed) {
		this.transform.eulerAngles = new Vector3((float)transform.localEulerAngles.x + (float)(x) * speed, (float)transform.localEulerAngles.y + (float)(y) * speed, (float)transform.localEulerAngles.z + (float)(z) * speed);
	}

    private void Update()
    {
        switch (moveMode)
        {
            case move_mode.PlayerMove:
                keymove();
            break;

            case move_mode.CpuMove:

            break;
        }
    }

    private void keymove()
    {
        CharactorMove( 0,0, keygetter.postMoveingKey()[1], MoveSpeed);
        if (keygetter.postMoveingKey()[0] != 0)
        {
            CharactorRotation(0, keygetter.postMoveingKey()[0], 0, RotationSpeed);
        }
    }

}

