﻿/**
 * Unity C# Script
 * Audio Player Defalt Source
 * Date : 2015/12/20
 * Author :animeing
**/

using UnityEngine;

[RequireComponent(typeof(AudioSource))]
public class AudioController : MonoBehaviour
{
    private int nowPlaying;
    private AudioSource audioSource;
    public AudioClip[] audioClip;

    void Awake() {
        audioSource = this.GetComponent<AudioSource>();
    }

    void Start() {
        this.nowPlaying = 0;
    }

    public void audioSetter(int selector) { 
        audioSource.clip = this.audioClip[selector];
        this.setplaying(selector);
    }

    public void audioSelector(int selector) {
        audioSource.clip = audioClip[selector];
        this.setplaying(selector);
        this.audioPlay();
    }

    public void audioVolumeSetPlay(int volume) {
        this.audioVolume(volume);
        this.audioPlay();
    }

    public void audioVolumeSetPlay(int selector, int volume) {
        this.audioSelector(selector);
        this.audioVolume(volume);
        this.audioPlay();
    }

    public void audioNextSet() {
        this.audioSetter(nowPlaying ++);
    }

    public void audioNextSetPlay(){
        this.audioSetter(nowPlaying ++);
        this.audioPlay();
    }

    public void audioPreSet() {
        this.audioSetter(nowPlaying--);
    }

    public void audioPrePlay() {
        this.audioSetter(nowPlaying--);
        this.audioPlay();
    }

    public void audioVolume(int volume) {
        audioSource.volume = volume;
    }

    public int audioSetNo() {
        return this.nowPlaying;
    }

    public int audioLength() {
        return audioClip.Length;
    }

    public void audioPlay() {
        audioSource.Play();
    }

    public void audioStop() {
        audioSource.Stop();
    }

    public bool audioIsPlay() {
        return audioSource.isPlaying;
    }

    public bool audioMute() {
        if (audioSource.mute){
            audioSource.mute = false;
        } else {
            audioSource.mute = true;
        }
        return audioSource.mute;
    }

    public bool audioLoop() {
        if (audioSource.loop) {
            audioSource.loop = false;
        } else {
            audioSource.loop = true;
        }
        return audioSource.loop;
    }

    public bool audioLoop(bool b)
    {
        audioSource.loop = b;
        return audioSource.loop;
    }

    public float audioPlayTime() {
        return audioSource.time;
    }

    private void setplaying(int set) {
        this.nowPlaying = set;
    }
}
