<?php
require_once CMS_IMPORT_DIR."/Sys/contentList/definary.php";
define("PAGE", str_replace(CMVtopPage, "",FULLPATH));
define("LOCATION_FILE",trim(PAGE,"/"));
require_once CMS_IMPORT_DIR."/Sys/title.php";
/* 
 * HTML contentを出力する為のクラス
 * package MyCMS
 */
class site_direct{
	//コンストラクタ
	function site_direct(){}
	//アクセスURLから目的のページを引っ張りだす
	function data(){
		global $set;
		$title = new Title();
		$addhead = new AddHead();
		//必要な部分のURLを切り出す
		$pageNotFound = CMVtopPage;
		try{
			@$pars = (explode("/",parse_url(PAGE)["path"]));
			if(!isset($pars)){
				$pars[1] = "";
			}
			$locationFile = str_replace("/", "^", LOCATION_FILE);
		}catch(ErrorException $e){
			$pars[1] = "";
		}

		//TODO URLから適切なページを出力する
		switch ($pars[1]) {
			case 'admin':
				//TODO 管理ページ処理
				$s = $locationFile.".html";
				echo $s;
				$ret = @file_get_contents(dirname(dirname(__dir__))."/site/admin/".str_replace("/","^",$s));
				if($ret !== false){
					return $ret;
				} else {
					header('HTTP', true, 404);
				}

			break;
			
			case 'genre':
				//TODO 投稿ページ処理
			break;
			
			default :
				//TODO 固定ページ処理
			//設定ファイルの読み込み
				$s = $locationFile.".ini";
				if($s == ".ini"){
					$s = "index.ini";
				}
				if(file_exists(dirname(dirname(__dir__))."/site/setting/".str_replace("/","^",$s))){
					$set = parse_ini_file(dirname(dirname(__dir__))."/site/setting/".str_replace("/","^",$s));
				} else {
					$set = false;
				}
			//ページデータの読み込み
				$s = $locationFile.".html";
				if($s == ".html"){
					$s = "index.html";
				}
				$ret = @file_get_contents(dirname(dirname(__dir__))."/site/view/".str_replace("/","^",$s));
			//設定ファイル・ページデータの対データの有無確認
				if($ret !== false && $set !== false){
			//設定ファイル・ページデータの対データの有
				//ページ公開日の確認
					if($set["draftDate"] === false || strtotime(date("Y/m/d")) >= strtotime($set["draftDate"])){
						//ページ公開日内 (ページ表示)
						$addhead->Add("title","title",null,$title->HeadTitle($set["title"]));
						return $ret;
					} else {
						//ページ公開日外 (ページ非表示)
						return $this->page_was_hiding($set);
					}
				} else {
			//設定ファイル・ページデータの対データの無(どちらかのデータがないということはページがないということだから404扱い)
					return $this->red404();
				}
			break;
		}
	}

///<summary>ページ隠蔽設定確認</summary>
	private function page_was_hiding($set){
		if($set["draftHiding"] == "false"){
			//ページは存在するが、アクセス拒否状態の為、403
			return $this->red403();
		} else {
			//ページの存在を隠蔽するため404
			return $this->red404();
		}
	}

///<summary>エラーページの出力選択</summary>
///<param name=ret>ページview用の空変数</param>
///<param name=set>ページsetting用の空変数</param>
	private function context(&$ret,&$set,$actionname){
		$s = $actionname.".ini";
		if(file_exists(dirname(__dir__)."/theme/".THEME_NAME."/error/setting/".str_replace("/","^",$s))){
			$set = parse_ini_file(dirname(__dir__)."/theme/".THEME_NAME."/error/setting/".str_replace("/","^",$s));
		} else {
			$set = false;
		}
		$s = $actionname.".html";
		$ret = @file_get_contents(dirname(__dir__)."/theme/".THEME_NAME."/error/view/".str_replace("/","^",$s));
		header('HTTP', true, $this->red_requestCode($actionname));
	}

///<summary>リクエストコードを返す</summary>
///<param name=actionname>アクションネーム</param>
	private function red_requestCode($actionname){
		switch ($actionname) {
			case "accessForbidden":
				return 403;
			case "notFound":
			default:
				return 404;
		}
	}

///<summary>404ページ設定</summary>
	private function red404(){
		$title = new Title();
		$addhead = new AddHead();
		$ret = $set = "";
		$this->context($ret,$set,"notFound");
		$addhead->Add("title","title",null,$title->HeadTitle($set["title"]));
		$addhead->Add("meta","robot",array("name"=>"robots","content"=>"noindex,nofollow,noarchive,noodp,noydir"));
		$addhead->Unfrag("markup");
		return $ret;
	}

///<summary>403ページ設定</summary>
	private function red403(){
		$title = new Title();
		$addhead = new AddHead();
		$ret = $set = "";
		$this->context($ret,$set,"accessForbidden");
		$addhead->Add("title","title",null,$title->HeadTitle($set["title"]));
		$addhead->Add("meta","robot",array("name"=>"robots","content"=>"noindex,nofollow,noarchive,noodp,noydir"));
		$addhead->Unfrag("markup");
		return $ret;
	}

}

?>