<?php
/* 
 * HTML headを出力するためのクラス
 * @package MyCMS
 */
define("CMS_IMPORT_DIR", dirname(__dir__));
ob_start();
require_once dirname(__dir__)."/Sys/import/import.php";
$mycms_ExtensionCode = new ExtensionControl();
$mycms_ExtensionCode->ExtensionFuncCheck();
$mycms_ExtensionCode->EXStart();
require_once dirname(__dir__)."/Sys/title.php";
ob_get_clean();

class AddHead{
	private $headResponse = null;
	//必要最低限のheadを登録しておく
	function AddHead(){
		global $headResponse,$siteTemp;
		if($headResponse === null){
			ob_start();
			$title = new Title();
			$markup = new TagCreater("script",array("type"=>"application/Id+json"));
			//マークアップ設定を行い、今後のTagCreaterの出力するスラッシュ閉じタグのスラッシュを削除する
			$markup -> Add("
{
	\"@content\":\"http://schema.org\",
	\"name\":\"".TITLE."\",
	\"url\":\"".FULLPATH."\"
}",
				false
			);
			$markup = $markup->Out();
			$style = new TagCreater("link",array("rel"=>"stylesheet","type"=>"text/css","media"=>"all","href"=>$this->Style()));
			$style = $style->Out();

			$jquery = new TagCreater("script",array());
			$jquery->AddProperty(array("type"=>"text/javascript","src"=>CMVtopPage."/js/jquery-1.11.1.min.js"));
			$jquery = $jquery->Out();

			$meta = new TagCreater("meta");
			$meta->AddProperty(array("name"=>"viewport","content"=>VIEWPORT));
			$viewport = $meta->Out();

			$meta->AddProperty(array("charset"=>CHARSET));
			$charset=$meta->Out();

			$meta->AddProperty(array("http-equiv"=>"Content-type","content"=>"text/html;charset=".CHARSET));
			$contentType = $meta->Out();
	
			$meta->AddProperty(array("http-equiv"=>"Content-style-type","content"=>"text/css"));
			$contentCss = $meta->Out();
	
			$meta->AddProperty(array("http-equiv"=>"Content-script-type","content"=>"text/javascript"));
			$contentJs = $meta->Out();
			require_once dirname(__dir__)."/Sys/contentList/Response.php";
			$mycms_ExtensionCode = new ExtensionControl();
			$mycms_ExtensionCode->EXHead();
			unset($mycms_ExtensionCode);
			ob_get_clean();
		}
	}

	///<summary>登録してあるheadを有効化する</summary>
	///<param name=key>登録された有効化するheadキー</param>
	function Active($key){
		global $headResponse;
		$headResponse[$key] = array($headResponse[$key][0],true);
	}

	///<summary>出力するheadリストを追加する</summary>
	///<param name=tag>headのタグ</param>
	///<param name=key>headを識別するheadリスト内で一意のキー</param>
	///<param name=property>タグ内に記載する内容(連想配列 パラメータ名=>パラメータ)</param>
	///<param name=content>タグ開けと閉じの間に記載する内容(string)</param>
	function Add($tag,$key,$property = null,$content = null){
		global $headResponse;
		$tag = new TagCreater($tag);
		if($content != null){
			$tag->Add($content);
		}
		if($property != null){
			$tag->AddProperty($property);
		}
		$headResponse[$key] = array(($tag->Out()),true);
	}

	///<summary>登録されているheadの出力をしないようにする</summary>
	///<param name=key>対象のheadデータのキー</param>
	function Unfrag($key){
		global $headResponse;
		$headResponse[$key] = array($headResponse[$key][0],false);
	}

	function getTitle(){
		return 0;
	}

	///<summary>出力するheadを返す</summary>
	///<return>headを出力する</return>
	function CallHead(){
		global $headResponse;
		$ret = "";
		foreach ($headResponse as $key => $value) {
			if($value[1]){
				$ret .= $value[0].PHP_EOL;
			}
		}
		$comp = new Compless();
		$headResponse = null;
		return $comp->callcomp($ret);
	}

	///<summary>headを出力する</summary>
	function ViewHead(){
		echo CallHead();
	}

	///<summary>外面に出る架空のcssリンクを返す</summary>
	///<retrun>選択されているテーマの出力されているcssリンク</return>
	function Style(){
		return CMVtopPage."/css/style.css";
	}
	
	///<summary>占有しているheadリストを解放する</summary>
	function close(){
		unset($headResponse);
	}
}
