<?php
define("EX_PATH" , dirname(dirname(__dir__))."\\extensions\\");
class ExtensionControl{

	private static $ExtensionList = null;
	private static $ExCont;
	private static $EX_Classes;
	private static $Ex_setting;
	function ExtensionControl(){
		global $ExtensionList;
		if($ExtensionList === null){
			$ExtensionList = scandir(EX_PATH);
			unset($ExtensionList[0]);
			unset($ExtensionList[1]);
			$ExtensionList = array_values($ExtensionList);
		}
	}

	function ExtensionFuncCheck(){
		global $ExtensionList,$ExCont,$EX_Classes,$Ex_setting;
		$com = new Compless();
		$funcs = array();
		$serchList = $ExtensionList;
		foreach ($serchList as $key=>$ExtensionName) {
			$check = EX_PATH.$ExtensionName;
			if(is_dir($check)){
				$temple = @file_get_contents(EX_PATH.$ExtensionName."//".$ExtensionName.".php");
				if($temple !== false){
					$temple = preg_replace('[//.*\r\n]',"",$temple);
					$temple = $com->callcomp($temple,true);
					//スクリプトに特殊関数が含まれているか判断した結果が入る
					$ExCont[$ExtensionName] =
						array(
							"start"=>strpos($temple, "function Start"),
							"responseHead"=>strpos($temple, "function ResponseHead"),
							"head"=>strpos($temple, "function Head"),
							"loaded"=>strpos($temple, "function Page_Loaded"),
							"viewOverraid"=>strpos($temple, "function OverraidBody"),
							"viewAdd"=>strpos($temple, "function AddCode"),
							"viewBodyStart"=>strpos($temple, "function BodyStart"),
							"viewded"=>strpos($temple, "function Viewded")
						);
					require_once (EX_PATH.$ExtensionName."//".$ExtensionName.".php");
					$Ex_setting[$ExtensionName]=parse_ini_file(EX_PATH.$ExtensionName."/control.ini");
					$EX_Classes[$ExtensionName] = new $ExtensionName();
				} else {
					unset($ExtensionList[$key]);
					$ExtensionList = array_values($ExtensionList);
				}
			} else {
				unset($ExtensionList[$key]);
				$ExtensionList = array_values($ExtensionList);
			}
		}
		unset($ExtensionList);
	}

//指定されたタイミングの特殊関数をすべてのextensionに対して実行する
	private function EX_Query($timing,$exadd = null){
		//タイミングを関数名に変換するためのリスト
		$funclist = array(
			"start"=>"Start",
			"responseHead"=>"ResponseHead",
			"head"=>"Head",
			"loaded"=>"Page_Loaded",
			"viewOverraid"=>"OverraidBody",
			"viewAdd"=>"AddCode",
			"viewBodyStart"=>"BodyStart",
			"viewded"=>"Viewded"
		);


		global $ExCont,$EX_Classes,$Ex_setting;
		$retC = null;
		foreach ($ExCont as $key => $value) {
			if($value[$timing] !== false && $Ex_setting[$key][$timing]){
				if(!$Ex_setting[$key]["viewarrow"]){
					ob_start();
				}
				$retC[$key] = $EX_Classes[$key]->$funclist[$timing]($exadd);
				if(!$Ex_setting[$key]["viewarrow"]){
					ob_get_clean();
				}
			}
		}
		return $retC;
	}

//呼び出し関数
	function EXStart(){
		$this->EX_Query("start");
	}

	function EXResponse(){
		$this->EX_Query("responseHead");
	}

	function EXHead(){
		$this->EX_Query("head",new AddHead(true));
	}

	function EXLoaded(){
		$this->EX_Query("loaded",new AddHead(true));
	}

//viewのoverraidするページのデータを返す
	function EXViewOverraid(){
		$data = $this->EX_Query("viewOverraid");
		$key = @key(array_slice($data, 0, 1, true));
		return $data[$key][$key];
	}

//変換コードに変換して結果を返す
	function EXAddCode(){
		global $EX_Classes;
		$rep = $this->EX_Query("viewAdd");
		$ret = null;
		if($rep != null){
			foreach ($rep as $class => $repArray) {
				foreach ($repArray as $key => $value) {
					if(is_numeric($key)){
						$ret["<!--[".$class."(".$value.")]-->"] = $EX_Classes[$class]->$value();
					} else {
						$ret["<!--[".$class."(".$key.")]-->"] = $value;
					}
				}
			}
		}
		return $ret;
	}

	function EXBodyStart(){
		$this->EX_Query("viewBodyStart");
	}

	function EXViewended(){
		$this->EX_Query("viewded");
	}

}
